/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.entities.wallcap;

import com.google.inject.Inject;
import com.google.inject.ProvidedBy;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import technology.rocketjump.undermount.assets.entities.wallcap.WallCapAssetDictionaryProvider;
import technology.rocketjump.undermount.assets.entities.wallcap.model.WallCapAsset;
import technology.rocketjump.undermount.assets.model.GameMaterialType;
import technology.rocketjump.undermount.doors.Doorway;
import technology.rocketjump.undermount.doors.DoorwayOrientation;
import technology.rocketjump.undermount.doors.DoorwaySize;
import technology.rocketjump.undermount.entities.model.physical.furniture.DoorwayEntityAttributes;

@ProvidedBy(value=WallCapAssetDictionaryProvider.class)
@Singleton
public class WallCapAssetDictionary {
    private final Map<String, WallCapAsset> assetsByName = new ConcurrentHashMap<String, WallCapAsset>();
    private final Map<Long, Map<GameMaterialType, Map<DoorwayOrientation, Map<DoorwaySize, WallCapAsset>>>> typedMap = new ConcurrentHashMap<Long, Map<GameMaterialType, Map<DoorwayOrientation, Map<DoorwaySize, WallCapAsset>>>>();

    @Inject
    public WallCapAssetDictionary(List<WallCapAsset> completeAssetList) {
        for (WallCapAsset asset : completeAssetList) {
            this.assetsByName.put(asset.getUniqueName(), asset);
            if (!this.typedMap.containsKey(asset.getWallTypeId())) {
                this.typedMap.put(asset.getWallTypeId(), new ConcurrentHashMap());
            }
            this.addToMapByMaterialType(asset, asset.getDoorwayMaterialType(), this.typedMap.get(asset.getWallTypeId()));
        }
    }

    public WallCapAsset getMatching(Doorway doorway, DoorwayEntityAttributes wallCapAttributes) {
        Map<GameMaterialType, Map<DoorwayOrientation, Map<DoorwaySize, WallCapAsset>>> materialMap = this.typedMap.get(wallCapAttributes.getAttachedWallType().getWallTypeId());
        if (materialMap == null) {
            return null;
        }
        Map<DoorwayOrientation, Map<DoorwaySize, WallCapAsset>> orientationMap = materialMap.get((Object)doorway.getDoorwayMaterialType());
        if (orientationMap == null) {
            return null;
        }
        Map<DoorwaySize, WallCapAsset> sizeMap = orientationMap.get((Object)doorway.getOrientation());
        if (sizeMap == null) {
            return null;
        }
        return sizeMap.get((Object)doorway.getDoorwaySize());
    }

    private void addToMapByMaterialType(WallCapAsset asset, GameMaterialType doorwayMaterialType, Map<GameMaterialType, Map<DoorwayOrientation, Map<DoorwaySize, WallCapAsset>>> assetMap) {
        if (doorwayMaterialType == null) {
            for (GameMaterialType gameMaterialType : GameMaterialType.values()) {
                this.addToMapByMaterialType(asset, gameMaterialType, assetMap);
            }
            return;
        }
        if (!assetMap.containsKey((Object)doorwayMaterialType)) {
            assetMap.put(doorwayMaterialType, new ConcurrentHashMap());
        }
        this.addToMapByOrientation(asset, assetMap.get((Object)doorwayMaterialType));
    }

    private void addToMapByOrientation(WallCapAsset asset, Map<DoorwayOrientation, Map<DoorwaySize, WallCapAsset>> assetMap) {
        if (!assetMap.containsKey((Object)asset.getDoorwayOrientation())) {
            assetMap.put(asset.getDoorwayOrientation(), new ConcurrentHashMap());
        }
        this.addToMapByDoorwaySize(asset, assetMap.get((Object)asset.getDoorwayOrientation()));
    }

    private void addToMapByDoorwaySize(WallCapAsset asset, Map<DoorwaySize, WallCapAsset> assetMap) {
        if (assetMap.containsKey((Object)asset.getDoorwaySize())) {
            throw new RuntimeException("Duplicated wall cap asset: " + asset.toString());
        }
        assetMap.put(asset.getDoorwaySize(), asset);
    }
}

